<?php
session_start();
require_once '../includes/db_connect.php';

$error = '';

if (isset($_POST['signup'])) {
    $name  = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm = $_POST['confirm_password'];

    // Check passwords
    if ($password !== $confirm) {
        $error = "Passwords do not match!";
    } else {
        // Check if email exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $error = "Email already registered!";
        } else {
            // Hash password
            $hash = password_hash($password, PASSWORD_DEFAULT);

            // Insert new user
            $insert = $conn->prepare("INSERT INTO users (name, email, password, role, created_at) 
                                      VALUES (?, ?, ?, 'user', NOW())");
            $insert->bind_param("sss", $name, $email, $hash);

            if ($insert->execute()) {
                // Auto-login
                $_SESSION['user_id'] = $insert->insert_id;
                $_SESSION['user_name'] = $name;
                $_SESSION['role'] = 'user';

                header("Location: ../user/dashboard.php");
                exit;
            } else {
                $error = "Something went wrong during registration.";
            }
            $insert->close();
        }
        $stmt->close();
    }
}

include '../includes/header.php';
?>

<h2>SIGN UP</h2>

<form method="post">
    <?php if ($error): ?>
        <p class="error"><?php echo $error; ?></p>
    <?php endif; ?>

    <input type="text" name="name" placeholder="Full Name" required>
    <input type="email" name="email" placeholder="Email" required>
    <input type="password" name="password" placeholder="Password" required>
    <input type="password" name="confirm_password" placeholder="Confirm Password" required>
    
    <button type="submit" name="signup">Sign Up</button>

    <p>Already have an account? 
        <a href="<?php echo $base_path; ?>auth/login.php">Log in</a>
    </p>
</form>

<?php include '../includes/footer.php'; ?>
